//=============================================================================
// ActionScriptSelfSwitchReset.js
//============================================================================

/*:
 * @plugindesc ActionScriptSelfSwitchReset layout.
 * @author T.Sugiura
 *
 * @help ActionScriptSelfSwitchReset
 */

/*:ja
 * @plugindesc MVアクションスクリプト用、セルフスイッチオフプラグイン
 * @author T.Sugiura
 *
 * @help ActionScriptSelfSwitchReset
 * ※場所移動する前にこれを実行してください
 */
 
 (function() 
 {
 	
 	var parameters = PluginManager.parameters('ActionScriptSelfSwitchReset');
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;

	Game_Interpreter.prototype.pluginCommand = function(command, args)
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if(command === "ActionScriptSelfSwitchReset")
		{
			
			//マップ上にあるデータから、セルフスイッチをOFFにします
			for(var i = 1; i <= $gameMap.events().length ; i++)
			{
				
				key1 = [$gameMap._mapId, i, "A"];
				key2 = [$gameMap._mapId, i, "B"];
				key3 = [$gameMap._mapId, i, "C"];
				key4 = [$gameMap._mapId, i, "D"];
				
				$gameSelfSwitches.setValue(key1, false);
				$gameSelfSwitches.setValue(key2, false);
				$gameSelfSwitches.setValue(key3, false);
				$gameSelfSwitches.setValue(key4, false);
				
			}
		}
		
	}
 	
 })();